/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class GuiNpcPngAnimation {
    private final int mcmetaFrameTime;
    private final int mcmetaFrameSize;
    private long mcmetaCurrentTime = 0L;
    private final long mcmetaTotalTime;
    private final int[] mcmetaFrames;
    private final int[] mcmetaTexturesFrames;

    public GuiNpcPngAnimation(int width, int height, int baseTextureId, JsonObject animation) {
        this.mcmetaFrameTime = animation.get("frametime") != null ? animation.get("frametime").getAsInt() : 0;
        this.mcmetaFrameSize = animation.get("framesize") != null ? animation.get("framesize").getAsInt() : height / width;
        if (animation.getAsJsonArray("frames") != null) {
            JsonArray frames = animation.getAsJsonArray("frames");
            this.mcmetaFrames = new int[frames.size()];
            this.mcmetaTexturesFrames = new int[frames.size()];
            for (int i = 0; i < frames.size(); ++i) {
                this.mcmetaFrames[i] = frames.get(i).getAsInt();
                this.mcmetaTexturesFrames[i] = baseTextureId;
            }
        } else {
            this.mcmetaFrames = new int[this.mcmetaFrameSize];
            this.mcmetaTexturesFrames = new int[this.mcmetaFrameSize];
            for (int i = 0; i < this.mcmetaFrames.length; ++i) {
                this.mcmetaFrames[i] = i;
                this.mcmetaTexturesFrames[i] = baseTextureId;
            }
        }
        this.mcmetaTotalTime = (long)this.mcmetaFrames.length * (long)this.mcmetaFrameTime;
    }

    public void createEntityIDs() {
        int textureId = GL11.glGetInteger((int)32873);
        int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        int heightSize = height / this.mcmetaFrameSize;
        ByteBuffer baseBuffer = BufferUtils.createByteBuffer((int)(width * height * 4));
        GL11.glBindTexture((int)3553, (int)textureId);
        GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)baseBuffer);
        for (int i = 0; i < this.mcmetaFrameSize; ++i) {
            int h;
            ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * heightSize * 4));
            int j = h = i * (width * heightSize);
            int k = 0;
            while (j < h + width * heightSize) {
                buffer.put(k * 4, baseBuffer.get(j * 4));
                buffer.put(k * 4 + 1, baseBuffer.get(j * 4 + 1));
                buffer.put(k * 4 + 2, baseBuffer.get(j * 4 + 2));
                buffer.put(k * 4 + 3, baseBuffer.get(j * 4 + 3));
                ++j;
                ++k;
            }
            this.mcmetaTexturesFrames[i] = GL11.glGenTextures();
            GL11.glBindTexture((int)3553, (int)this.mcmetaTexturesFrames[i]);
            GL11.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
            GL11.glTexParameterf((int)3553, (int)10240, (float)9728.0f);
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)heightSize, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        }
    }

    private int getFrame() {
        if (this.mcmetaFrameTime != 0 && this.mcmetaTotalTime != 0L) {
            double time = this.mcmetaCurrentTime;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e != null) {
                time = (double)mc.field_71441_e.func_82737_E() % (double)this.mcmetaTotalTime;
            } else {
                ++this.mcmetaCurrentTime;
                if (this.mcmetaCurrentTime >= this.mcmetaTotalTime) {
                    this.mcmetaCurrentTime = 0L;
                }
            }
            return (int)Math.floor(time / (double)this.mcmetaFrameTime);
        }
        return 0;
    }

    public int getFrameId() {
        if (this.mcmetaFrames.length != 0) {
            return this.mcmetaFrames[this.getFrame()];
        }
        return 0;
    }

    public int getFrameEntityId() {
        if (this.mcmetaTexturesFrames.length != 0) {
            return this.mcmetaTexturesFrames[this.getFrame()];
        }
        return 0;
    }
}

